# jama-vue-client

## Project setup
```
yarn install
```

## Jama Service Auth

create a `.env.local` file for Jama service connection settings, for example :

```
VUE_APP_JAMA_END_POINT=http://localhost:8000/rpc/
VUE_APP_JAMA_API_KEY=myJamaApiKey
```



### Compiles and hot-reloads for development
```
yarn serve
```

### Compiles and minifies for production

Set app title (nav bar label) in `.env.local` file & base url if needed:

```
VUE_APP_TITLE=My app title
VUE_APP_URL_PATH=/my-base-url/
```
then build with 
```
yarn build
```


**note :** `dist/assets` folder must be served at `https://mysite.mydomain/myroute/assets`


### Lints and fixes files
```
yarn lint
```

# Usage

```
yarn add @chauveau/vue-jama
```

Your ~/.npmrc must contains :

```
@chauveau:registry=https://git.unicaen.fr/api/v4/packages/npm/
```

## Import

```
import {VueJamaApp} from "@chauveau/vue-jama";

or

import {VueJamaDialog} from "@chauveau/vue-jama";


```

## Build lib

```
yarn build-lib
```

## Publish

```
npm publish
```

## reference the component via `<vue-jama-dialog>` or `<vue-jama-app>` tag as following

```

const options = {
                  apiKey: 'jama api key',
                  endPoint: 'jama endpoint',
                  defaudialogltCollection: '/path',
                  appTitle: 'app title',
                  selectionMode: true || false
};

            
<vue-jama-dialog
        :options="dialogOptions"
        @resource-selected="resourceSelectedCallBack"
></vue-jama-dialog>
          
OR

<vue-jama-app :options="dialogOptions"
              @resource-selected="resourceSelectedCallBack">
</vue-jama-app>
```



### Customize configuration
See [Configuration Reference](https://cli.vuejs.org/config/).

