import {Sha256 as hash256} from 'asmcrypto.js';


function toHexString(byteArray) {
    return Array.from(byteArray, function (byte) {
        return ('0' + (byte & 0xFF).toString(16)).slice(-2);
    }).join('')
}

export default class ChecksumService {

    async sha256(file) {
        let hasher = new hash256();
        const sliceSize = 8192; // 8ko
        let start = 0;
        while (start < file.size) {
            const slice = await this._readSlice(file, start, sliceSize);
            hasher.process(slice);
            start += sliceSize;
        }
        hasher.finish();
        return toHexString(hasher.result);
    }

    /**
     *
     * @param file
     * @param start
     * @param size
     * @returns {Promise<boolean>}
     * @private
     */
    async _readSlice(file, start, size) {
        return new Promise((resolve, reject) => {
            const fileReader = new FileReader();
            const slice = file.slice(start, start + size);

            fileReader.onload = () => resolve(new Uint8Array(fileReader.result));
            fileReader.onerror = reject;
            fileReader.readAsArrayBuffer(slice);
        });
    }

}

