const FOLDERS_ONLY_MODE = 1;
const ALL_MODE = 2;
class DirectoryDropReader {

    constructor(items, mode = ALL_MODE) {
        this.items = items;
        this.nbItems = items.length;
        this.droppedFiles = []
        this.finishCallback = null;
        this.mode = mode;
    }

    read(cb) {
        this.finishCallback = cb;
        //var entry = this.items[0].webkitGetAsEntry();
        for (let i = 0; i < this.nbItems; i++) {
            this.readItem(this.items[i].webkitGetAsEntry(), true);
        }
    }

    readItem(item, isRoot = false) {
        if(!item)
            return;
        if (item.isDirectory) {
            let elemReader = item.createReader();
            let isLastDir = true;
            let dirRead =  () => {
                elemReader.readEntries( (subelems) => {
                    if (!subelems.length) {
                        this.finisher(isLastDir);
                    } else {
                        for (let i = 0; i < subelems.length; i++) {
                            this.readItem(subelems[i]);
                            isLastDir = isLastDir && subelems[i].isFile;
                        }
                        dirRead();
                    }
                });
            };
            dirRead();
        }
        if (item.isFile) {
            item.file( (efile) => {
                this.droppedFiles.push(efile);
                this.finisher(isRoot);
            });
        }
    }

    finisher(isFull) {
        if(isFull && this.finishCallback)
            this.finishCallback();

    }

    getDroppedFiles(){
        return this.droppedFiles;
    }

    /**
     *
     * @param DataTransferItemList items
     */
    static areFoldersOnly(items){
        for(let i = 0; i < items.length; i++) {
            let item = items[i].webkitGetAsEntry();
            if(!item.isDirectory){
                return false;
            }
        }
        return true;
    }
}

export {DirectoryDropReader, FOLDERS_ONLY_MODE, ALL_MODE}
