export default class VuetifyUtils {

    static prepareTreeViewCollections(cols, ancestors) {
        let prepared = [];
        let ancestorsIds = VuetifyUtils.prepareTreeViewAncestorsIds(ancestors)||[];
        for(let i = 0 ; i < cols.length; i++) {
            let col = {
                title: cols[i].title,
                id: cols[i].id,
                locked: ancestorsIds.indexOf(cols[i].id) >= 0
            }
            if(cols[i].descendants_count > 0)
                col.children = []
            prepared.push(col)
        }
        return prepared;
    }

    static prepareTreeViewAncestorsIds(ancestors){
        let prepared = [];
        for(let i = 0 ; i < ancestors.length; i++) {
            let leaf = ancestors[i].slice(-1)[0];
            prepared.push(leaf.id)
        }
        return prepared
    }
}
